# Voter List API - System Workflow

## 📊 User Registration & Approval Flow

```
┌─────────────────────────────────────────────────────────────────────┐
│                          USER REGISTRATION FLOW                      │
└─────────────────────────────────────────────────────────────────────┘

    [Mobile App]                 [API]                   [Database]
         │                        │                          │
         │  POST /api/register    │                          │
         ├───────────────────────>│                          │
         │  {email, phone, pwd}   │                          │
         │                        │  Insert User             │
         │                        ├─────────────────────────>│
         │                        │  role: "user"            │
         │                        │  is_approved: false      │
         │                        │                          │
         │  Response: Success     │<─────────────────────────┤
         │  "Wait for approval"   │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         ▼                        ▼                          ▼

┌─────────────────────────────────────────────────────────────────────┐
│                         USER LOGIN ATTEMPT                           │
└─────────────────────────────────────────────────────────────────────┘

    [Mobile App]                 [API]                   [Database]
         │                        │                          │
         │  POST /api/login       │                          │
         ├───────────────────────>│                          │
         │  {email, password}     │                          │
         │                        │  Check credentials       │
         │                        ├─────────────────────────>│
         │                        │                          │
         │                        │<─────────────────────────┤
         │                        │  User found              │
         │                        │  is_approved: false      │
         │                        │                          │
         │  403 Forbidden         │                          │
         │  "Not approved yet"    │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         ▼                        ▼                          ▼

┌─────────────────────────────────────────────────────────────────────┐
│                         ADMIN APPROVAL PROCESS                       │
└─────────────────────────────────────────────────────────────────────┘

    [Admin App]                  [API]                   [Database]
         │                        │                          │
         │  POST /api/login       │                          │
         ├───────────────────────>│  Check admin role        │
         │  {admin credentials}   ├─────────────────────────>│
         │                        │<─────────────────────────┤
         │  Response: Token       │  role: "admin"           │
         │<───────────────────────┤  is_approved: true       │
         │                        │                          │
         │  GET /api/admin/users  │                          │
         │  /pending              │                          │
         ├───────────────────────>│  Get unapproved users    │
         │  [Authorization Token] ├─────────────────────────>│
         │                        │<─────────────────────────┤
         │  Response: User list   │  WHERE is_approved=false │
         │<───────────────────────┤                          │
         │                        │                          │
         │  POST /api/admin/      │                          │
         │  users/{id}/approve    │                          │
         ├───────────────────────>│  Update user             │
         │  [Authorization Token] ├─────────────────────────>│
         │                        │  SET is_approved=true    │
         │                        │<─────────────────────────┤
         │  Response: Approved    │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         ▼                        ▼                          ▼

┌─────────────────────────────────────────────────────────────────────┐
│                     APPROVED USER - SUCCESSFUL LOGIN                 │
└─────────────────────────────────────────────────────────────────────┘

    [Mobile App]                 [API]                   [Database]
         │                        │                          │
         │  POST /api/login       │                          │
         ├───────────────────────>│                          │
         │  {email, password}     │  Check credentials       │
         │                        ├─────────────────────────>│
         │                        │                          │
         │                        │<─────────────────────────┤
         │                        │  User found              │
         │                        │  is_approved: true ✓     │
         │                        │                          │
         │                        │  Generate Token          │
         │  200 OK                │                          │
         │  {user, token}         │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         │  Store Token           │                          │
         │  Securely              │                          │
         │                        │                          │
         ▼                        ▼                          ▼

┌─────────────────────────────────────────────────────────────────────┐
│                        USER ACCESSING PROFILE                        │
└─────────────────────────────────────────────────────────────────────┘

    [Mobile App]                 [API]                   [Database]
         │                        │                          │
         │  GET /api/user/profile │                          │
         ├───────────────────────>│  Verify Token            │
         │  [Bearer Token]        │  Check is_approved       │
         │                        ├─────────────────────────>│
         │                        │<─────────────────────────┤
         │                        │  Approved ✓              │
         │  Response: User Data   │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         │  PUT /api/user/profile │                          │
         ├───────────────────────>│  Update allowed fields   │
         │  {phone, password}     ├─────────────────────────>│
         │                        │<─────────────────────────┤
         │  Response: Updated     │                          │
         │<───────────────────────┤                          │
         │                        │                          │
         ▼                        ▼                          ▼
```

## 🔐 Authentication & Authorization Layer

```
┌──────────────────────────────────────────────────────────────┐
│                    REQUEST PROCESSING                         │
└──────────────────────────────────────────────────────────────┘

Request → Middleware Chain → Controller → Response

1. PUBLIC ROUTES (No Authentication)
   POST /api/register
   POST /api/login
   ↓
   [No Middleware]
   ↓
   Controller processes request
   ↓
   Response


2. AUTHENTICATED ROUTES (Token Required)
   GET /api/me
   POST /api/logout
   ↓
   [auth:sanctum Middleware]
   - Verify Bearer token
   - Load user from token
   ↓
   Controller processes request
   ↓
   Response


3. ADMIN ROUTES (Admin Role Required)
   GET /api/admin/users
   POST /api/admin/users/{id}/approve
   ↓
   [auth:sanctum Middleware]
   → Verify token
   ↓
   [AdminMiddleware]
   → Check if user.role === 'admin'
   → If not: 403 Forbidden
   ↓
   Controller processes request
   ↓
   Response


4. USER ROUTES (Approved Status Required)
   GET /api/user/profile
   PUT /api/user/profile
   ↓
   [auth:sanctum Middleware]
   → Verify token
   ↓
   [ApprovedUserMiddleware]
   → Check if user.is_approved === true
   → If not: 403 "Wait for approval"
   ↓
   Controller processes request
   ↓
   Response
```

## 📊 Database Schema

```
┌─────────────────────────────────────────────────────────────┐
│                         USERS TABLE                          │
├────────────────┬──────────────┬──────────────────────────────┤
│ Column         │ Type         │ Description                  │
├────────────────┼──────────────┼──────────────────────────────┤
│ id             │ BIGINT       │ Primary Key (Auto Increment) │
│ email          │ VARCHAR(255) │ Unique, Required             │
│ phone          │ VARCHAR(20)  │ Unique, Required             │
│ password       │ VARCHAR(255) │ Hashed (bcrypt)              │
│ role           │ ENUM         │ 'admin' or 'user'            │
│                │              │ Default: 'user'              │
│ is_approved    │ BOOLEAN      │ Default: false               │
│ remember_token │ VARCHAR(100) │ For "Remember Me"            │
│ created_at     │ TIMESTAMP    │ Auto                         │
│ updated_at     │ TIMESTAMP    │ Auto                         │
└────────────────┴──────────────┴──────────────────────────────┘

Indexes:
- PRIMARY KEY: id
- UNIQUE: email
- UNIQUE: phone
- INDEX: role, is_approved (for filtering)
```

## 🔄 API Response Format

```json
SUCCESS RESPONSE:
{
    "success": true,
    "message": "Operation successful",
    "data": {
        // Response data here
    }
}

ERROR RESPONSE:
{
    "success": false,
    "message": "Error description"
}

VALIDATION ERROR (422):
{
    "message": "The email field is required.",
    "errors": {
        "email": ["The email field is required."],
        "phone": ["The phone has already been taken."]
    }
}
```

## 🎯 User Roles & Permissions

```
┌──────────────────────────────────────────────────────────────┐
│                        ROLE: ADMIN                            │
├──────────────────────────────────────────────────────────────┤
│ ✓ View all users                                             │
│ ✓ View pending users (not approved)                          │
│ ✓ Approve users                                              │
│ ✓ Reject/Disapprove users                                    │
│ ✓ Delete users (except other admins)                         │
│ ✓ Access own profile                                         │
│ ✓ Update own profile                                         │
│ ✗ Cannot be deleted by other admins                          │
│ ✗ Cannot be rejected/disapproved                             │
└──────────────────────────────────────────────────────────────┘

┌──────────────────────────────────────────────────────────────┐
│                        ROLE: USER                             │
├──────────────────────────────────────────────────────────────┤
│ ✓ Register (requires approval)                               │
│ ✓ Login (only if approved)                                   │
│ ✓ View own profile (only if approved)                        │
│ ✓ Update own profile (only if approved)                      │
│ ✗ Cannot access admin endpoints                              │
│ ✗ Cannot view other users                                    │
│ ✗ Cannot approve/reject users                                │
└──────────────────────────────────────────────────────────────┘
```

## 📱 Mobile App Integration Points

```
REGISTRATION SCREEN:
├─ Input: Email, Phone, Password, Confirm Password
├─ POST /api/register
└─ Show: "Success! Wait for admin approval"

LOGIN SCREEN:
├─ Input: Email, Password
├─ POST /api/login
├─ If 403: Show "Wait for approval message"
├─ If 200: Store token securely
└─ Navigate to: Dashboard

USER DASHBOARD (Approved Users):
├─ GET /api/user/profile (load user data)
└─ Headers: Authorization: Bearer {token}

ADMIN DASHBOARD (Admin Role):
├─ GET /api/admin/users (show all users)
├─ GET /api/admin/users/pending (show unapproved)
├─ POST /api/admin/users/{id}/approve (approve button)
└─ Headers: Authorization: Bearer {admin_token}

PROFILE EDIT SCREEN:
├─ Input: Phone, New Password (optional)
├─ PUT /api/user/profile
└─ Headers: Authorization: Bearer {token}

LOGOUT:
├─ POST /api/logout
├─ Headers: Authorization: Bearer {token}
└─ Clear stored token
```

---

**Legend:**

- ✓ = Allowed
- ✗ = Not Allowed
- → = Process Flow
- ↓ = Next Step
