# 🚀 QUICK START GUIDE - Voter List API

## Prerequisites

✅ XAMPP installed and running
✅ MySQL service started in XAMPP
✅ Composer installed globally

## Setup Steps (5 minutes)

### 1️⃣ Open Terminal

```bash
cd "d:\xampp\htdocs\New folder\voter-list-api"
```

### 2️⃣ Create Database

- Open: http://localhost/phpmyadmin
- Click "New" to create database
- Name: `voter_list`
- Click "Create"

### 3️⃣ Run Setup Script

```bash
setup.bat
```

This will:

- Install all dependencies
- Generate application key
- Run database migrations
- Create default admin and test user

### 4️⃣ Start Server

```bash
php artisan serve
```

✅ API Ready at: http://localhost:8000

---

## 🧪 Test Your API (Using Postman)

### Step 1: Import Collection

1. Open Postman
2. Click "Import"
3. Select file: `Voter_List_API.postman_collection.json`

### Step 2: Login as Admin

1. Select "Authentication" > "Login Admin"
2. Click "Send"
3. Token is automatically saved ✅

### Step 3: View All Users

1. Select "Admin" > "Get All Users"
2. Click "Send"
3. See admin and test user

### Step 4: Register New User

1. Select "Authentication" > "Register User"
2. Modify email and phone in request body
3. Click "Send"
4. Note the new user ID from response

### Step 5: Approve New User

1. Select "Admin" > "Approve User"
2. Change `{id}` in URL to the new user ID
3. Click "Send"
4. User is now approved! ✅

---

## 📋 Default Credentials

### Admin Account

```
Email: admin@voterlist.com
Password: admin123
```

### Test User Account

```
Email: user@example.com
Password: user123
Status: Not Approved (use admin to approve first)
```

---

## 📱 API Base URL

```
http://localhost:8000/api
```

---

## 🆘 Need Help?

📖 **Full Documentation**: Read `API_DOCUMENTATION.md`
📖 **Project Details**: Read `PROJECT_README.md`
🔧 **Troubleshooting**: Check README troubleshooting section

---

## ✅ Common Issues

**Issue**: Composer not found

```bash
# Download and install Composer from: https://getcomposer.org/
```

**Issue**: MySQL not connecting

```bash
# 1. Start MySQL in XAMPP Control Panel
# 2. Verify database 'voter_list' exists
# 3. Check .env file has correct credentials
```

**Issue**: Port 8000 already in use

```bash
# Use different port:
php artisan serve --port=8001
```

---

## 🎉 Success!

Your Voter List API is ready to use!

**Next Steps:**

1. Test all endpoints using Postman
2. Read full documentation
3. Integrate with your mobile app
4. Customize as needed

Happy coding! 🚀
